let LoadedMods = [];
let Modding = {
    _loadMods: null,
    _executeEvent: null,
    directives: [],
};

(function () {
    Modding._loadMods = ($compileProvider, cb) => {
        Remote.app.getMods(mods => {
            GetRootScope().options.installedMods.forEach(modName => {
                let mod = mods.find(x => x.name == modName);
                if (mod != null) {
                    let modObj = require(mod.startPath);

                    if (modObj.initialize == null) {
                        Helpers.ConsoleInfo(`Mod ${mod.displayName} failed: Missing initialize method`, 'warning');
                    } else {
                        modObj.initialize(mod.modPath, $compileProvider);

                        if (modObj.views != null) {
                            modObj.views.forEach(viewInfo => {
                                Modding.directives.push(viewInfo.name);
                                $compileProvider.directive(viewInfo.name, function () {
                                    return {
                                        restrict: 'E',
                                        templateUrl: viewInfo.viewPath,
                                        controller: viewInfo.controller,
                                        controllerAs: viewInfo.name + 'Ctrl'
                                    };
                                });
                            });
                        }

                        LoadedMods.push(modObj);
                        Helpers.ConsoleInfo(`Mod ${mod.displayName} loaded`);
                    }
                }
            });
            cb();
        });
    };

    Modding._executeEvent = (eventName, param1, param2, param3) => {
        LoadedMods.forEach(mod => {
            if (mod[eventName] != null) {
                mod[eventName](param1, param2, param3);
            }
        });
    };

    Modding.setMenuItem = menuItem => {
        GetRootScope().menuItems.push(menuItem);
    };

    Modding.setMenuItemBadgeCount = (name, amount) => {
        const menuItem = GetRootScope().menuItems.find(x => x.name.toLowerCase() == name.toLowerCase());
        if(menuItem != null) {
            menuItem.badgeCount = amount;
            GetRootScope().$broadcast(GameEvents.MenuChange);
        }
    };
})();